import { z } from 'zod';
import { type APIClient } from '../api';
export declare const ProjectExistsRequestSchema: z.ZodObject<{
    name: z.ZodString;
    organization_id: z.ZodString;
}, z.core.$strip>;
export declare const ProjectExistsResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodBoolean;
}, z.core.$strip>], "success">;
export type ProjectExistsRequest = z.infer<typeof ProjectExistsRequestSchema>;
export type ProjectExistsResponse = z.infer<typeof ProjectExistsResponseSchema>;
/**
 * Check if a project exists by name within an organization
 *
 * @param client
 * @param body
 * @returns
 */
export declare function projectExists(client: APIClient, body: ProjectExistsRequest): Promise<boolean>;
//# sourceMappingURL=exists.d.ts.map