import { join } from 'node:path';
import { randomUUID } from 'node:crypto';
/**
 * An implementation of the SessionEventProvider which uses JSON logs for delivery
 */
export class JSONSessionEventProvider {
    directory;
    constructor(directory) {
        this.directory = directory;
    }
    makeFilename(type) {
        return join(this.directory, `session-${type}.${Date.now()}${randomUUID()}.json`);
    }
    /**
     * called when the session starts
     *
     * @param event SessionStartEvent
     */
    async start(event) {
        const filename = this.makeFilename('start');
        const payload = JSON.stringify({ ...event, timestamp: new Date() }) + '\n';
        await Bun.file(filename).write(payload);
    }
    /**
     * called when the session completes
     *
     * @param event SessionCompleteEvent
     */
    async complete(event) {
        const filename = this.makeFilename('complete');
        const payload = JSON.stringify({ ...event, timestamp: new Date() }) + '\n';
        await Bun.file(filename).write(payload);
    }
}
//# sourceMappingURL=json.js.map