export interface EnvDiffEntry {
    key: string;
    /** The value from the "source" side (the side being pushed/pulled from) */
    sourceValue: string;
    /** The value from the "target" side (the side being overwritten), undefined if new */
    targetValue?: string;
    /** Whether the source side stores this as a secret */
    sourceIsSecret: boolean;
    /** Whether the target side stores this as a secret (undefined if new, i.e. no target) */
    targetIsSecret?: boolean;
}
export interface EnvDiff {
    newEntries: EnvDiffEntry[];
    changedEntries: EnvDiffEntry[];
    unchangedEntries: EnvDiffEntry[];
}
/**
 * Compute diff between source and target env/secrets.
 * "Source" is where values come from; "target" is what will be overwritten.
 *
 * For push: source=local, target=remote
 * For pull: source=cloud, target=local
 */
export declare function computeEnvDiff(sourceEnv: Record<string, string>, sourceSecrets: Record<string, string>, targetEnv: Record<string, string>, targetSecrets: Record<string, string>): EnvDiff;
export interface DisplayEnvDiffOptions {
    /** Label for the operation, shown in header. E.g. "push" or "pull" */
    direction: 'push' | 'pull';
}
/**
 * Display a diff view of env changes.
 * In TTY mode, shows a rich color-coded diff.
 * In non-TTY mode, shows simple text summary.
 */
export declare function displayEnvDiff(diff: EnvDiff, options: DisplayEnvDiffOptions): void;
//# sourceMappingURL=env-diff.d.ts.map