import { Command } from 'commander';
import type { CommandDefinition, CommandContext, Config, Logger } from './types';
import { type RegionList } from '@agentuity/server';
export declare function createCLI(version: string): Promise<Command>;
export interface ResolveRegionOptions {
    options: Record<string, unknown>;
    regions: RegionList;
    logger: Logger;
    required: boolean;
    region?: string;
    config?: Config | null;
    args?: Record<string, unknown> | unknown[];
}
export declare function resolveRegion(opts: ResolveRegionOptions): Promise<string | undefined>;
export declare function registerCommands(program: Command, commands: CommandDefinition[], baseCtx: CommandContext): Promise<void>;
//# sourceMappingURL=cli.d.ts.map