import { z } from 'zod';
import { APIResponseSchemaNoData } from '../api';
import { ThreadResponseError } from './util';
export const _ThreadDeleteRequestSchema = z.object({
    id: z.string().describe('the thread id'),
});
export const ThreadDeleteResponseSchema = APIResponseSchemaNoData();
/**
 * Delete a thread by id
 *
 * @param client
 * @param request
 * @returns
 */
export async function threadDelete(client, request) {
    const resp = await client.request('DELETE', `/thread/2025-03-17/${request.id}`, ThreadDeleteResponseSchema);
    if (!resp.success) {
        throw new ThreadResponseError({ message: resp.message });
    }
}
//# sourceMappingURL=delete.js.map