import type { ListSandboxesParams, ListSandboxesResponse } from '@agentuity/core';
import { z } from 'zod';
import { type APIClient } from '../api';
export declare const SandboxOrgInfoSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
}, z.core.$strip>;
export declare const SandboxRuntimeInfoSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    iconUrl: z.ZodOptional<z.ZodString>;
    brandColor: z.ZodOptional<z.ZodString>;
    tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
}, z.core.$strip>;
export declare const SandboxSnapshotUserInfoSchema: z.ZodObject<{
    id: z.ZodString;
    firstName: z.ZodOptional<z.ZodString>;
    lastName: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const SandboxSnapshotOrgInfoSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    slug: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export declare const SandboxSnapshotInfoSchema: z.ZodUnion<readonly [z.ZodObject<{
    id: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    tag: z.ZodOptional<z.ZodString>;
    fullName: z.ZodOptional<z.ZodString>;
    public: z.ZodLiteral<true>;
    org: z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        slug: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>;
}, z.core.$strip>, z.ZodObject<{
    id: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    tag: z.ZodOptional<z.ZodString>;
    fullName: z.ZodOptional<z.ZodString>;
    public: z.ZodLiteral<false>;
    user: z.ZodObject<{
        id: z.ZodString;
        firstName: z.ZodOptional<z.ZodString>;
        lastName: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>;
}, z.core.$strip>]>;
export declare const SandboxInfoSchema: z.ZodObject<{
    sandboxId: z.ZodString;
    identifier: z.ZodOptional<z.ZodString>;
    name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    status: z.ZodEnum<{
        idle: "idle";
        failed: "failed";
        deleted: "deleted";
        creating: "creating";
        running: "running";
        terminated: "terminated";
    }>;
    mode: z.ZodOptional<z.ZodString>;
    createdAt: z.ZodString;
    region: z.ZodOptional<z.ZodString>;
    runtime: z.ZodOptional<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        iconUrl: z.ZodOptional<z.ZodString>;
        brandColor: z.ZodOptional<z.ZodString>;
        tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
    }, z.core.$strip>>;
    snapshot: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
        id: z.ZodString;
        name: z.ZodOptional<z.ZodString>;
        tag: z.ZodOptional<z.ZodString>;
        fullName: z.ZodOptional<z.ZodString>;
        public: z.ZodLiteral<true>;
        org: z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            slug: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>;
    }, z.core.$strip>, z.ZodObject<{
        id: z.ZodString;
        name: z.ZodOptional<z.ZodString>;
        tag: z.ZodOptional<z.ZodString>;
        fullName: z.ZodOptional<z.ZodString>;
        public: z.ZodLiteral<false>;
        user: z.ZodObject<{
            id: z.ZodString;
            firstName: z.ZodOptional<z.ZodString>;
            lastName: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>;
    }, z.core.$strip>]>>;
    executions: z.ZodNumber;
    stdoutStreamUrl: z.ZodOptional<z.ZodString>;
    stderrStreamUrl: z.ZodOptional<z.ZodString>;
    networkEnabled: z.ZodOptional<z.ZodBoolean>;
    networkPort: z.ZodOptional<z.ZodNumber>;
    url: z.ZodOptional<z.ZodString>;
    org: z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>;
    timeout: z.ZodOptional<z.ZodObject<{
        idle: z.ZodOptional<z.ZodString>;
        execution: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>>;
    command: z.ZodOptional<z.ZodObject<{
        exec: z.ZodArray<z.ZodString>;
        mode: z.ZodOptional<z.ZodEnum<{
            oneshot: "oneshot";
            interactive: "interactive";
        }>>;
    }, z.core.$strip>>;
}, z.core.$strip>;
export declare const ListSandboxesDataSchema: z.ZodObject<{
    sandboxes: z.ZodArray<z.ZodObject<{
        sandboxId: z.ZodString;
        identifier: z.ZodOptional<z.ZodString>;
        name: z.ZodOptional<z.ZodString>;
        description: z.ZodOptional<z.ZodString>;
        status: z.ZodEnum<{
            idle: "idle";
            failed: "failed";
            deleted: "deleted";
            creating: "creating";
            running: "running";
            terminated: "terminated";
        }>;
        mode: z.ZodOptional<z.ZodString>;
        createdAt: z.ZodString;
        region: z.ZodOptional<z.ZodString>;
        runtime: z.ZodOptional<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            iconUrl: z.ZodOptional<z.ZodString>;
            brandColor: z.ZodOptional<z.ZodString>;
            tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
        }, z.core.$strip>>;
        snapshot: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
            id: z.ZodString;
            name: z.ZodOptional<z.ZodString>;
            tag: z.ZodOptional<z.ZodString>;
            fullName: z.ZodOptional<z.ZodString>;
            public: z.ZodLiteral<true>;
            org: z.ZodObject<{
                id: z.ZodString;
                name: z.ZodString;
                slug: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>;
        }, z.core.$strip>, z.ZodObject<{
            id: z.ZodString;
            name: z.ZodOptional<z.ZodString>;
            tag: z.ZodOptional<z.ZodString>;
            fullName: z.ZodOptional<z.ZodString>;
            public: z.ZodLiteral<false>;
            user: z.ZodObject<{
                id: z.ZodString;
                firstName: z.ZodOptional<z.ZodString>;
                lastName: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>;
        }, z.core.$strip>]>>;
        executions: z.ZodNumber;
        stdoutStreamUrl: z.ZodOptional<z.ZodString>;
        stderrStreamUrl: z.ZodOptional<z.ZodString>;
        networkEnabled: z.ZodOptional<z.ZodBoolean>;
        networkPort: z.ZodOptional<z.ZodNumber>;
        url: z.ZodOptional<z.ZodString>;
        org: z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>;
        timeout: z.ZodOptional<z.ZodObject<{
            idle: z.ZodOptional<z.ZodString>;
            execution: z.ZodOptional<z.ZodString>;
        }, z.core.$strip>>;
        command: z.ZodOptional<z.ZodObject<{
            exec: z.ZodArray<z.ZodString>;
            mode: z.ZodOptional<z.ZodEnum<{
                oneshot: "oneshot";
                interactive: "interactive";
            }>>;
        }, z.core.$strip>>;
    }, z.core.$strip>>;
    total: z.ZodNumber;
}, z.core.$strip>;
export declare const ListSandboxesResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        sandboxes: z.ZodArray<z.ZodObject<{
            sandboxId: z.ZodString;
            identifier: z.ZodOptional<z.ZodString>;
            name: z.ZodOptional<z.ZodString>;
            description: z.ZodOptional<z.ZodString>;
            status: z.ZodEnum<{
                idle: "idle";
                failed: "failed";
                deleted: "deleted";
                creating: "creating";
                running: "running";
                terminated: "terminated";
            }>;
            mode: z.ZodOptional<z.ZodString>;
            createdAt: z.ZodString;
            region: z.ZodOptional<z.ZodString>;
            runtime: z.ZodOptional<z.ZodObject<{
                id: z.ZodString;
                name: z.ZodString;
                iconUrl: z.ZodOptional<z.ZodString>;
                brandColor: z.ZodOptional<z.ZodString>;
                tags: z.ZodOptional<z.ZodArray<z.ZodString>>;
            }, z.core.$strip>>;
            snapshot: z.ZodOptional<z.ZodUnion<readonly [z.ZodObject<{
                id: z.ZodString;
                name: z.ZodOptional<z.ZodString>;
                tag: z.ZodOptional<z.ZodString>;
                fullName: z.ZodOptional<z.ZodString>;
                public: z.ZodLiteral<true>;
                org: z.ZodObject<{
                    id: z.ZodString;
                    name: z.ZodString;
                    slug: z.ZodOptional<z.ZodString>;
                }, z.core.$strip>;
            }, z.core.$strip>, z.ZodObject<{
                id: z.ZodString;
                name: z.ZodOptional<z.ZodString>;
                tag: z.ZodOptional<z.ZodString>;
                fullName: z.ZodOptional<z.ZodString>;
                public: z.ZodLiteral<false>;
                user: z.ZodObject<{
                    id: z.ZodString;
                    firstName: z.ZodOptional<z.ZodString>;
                    lastName: z.ZodOptional<z.ZodString>;
                }, z.core.$strip>;
            }, z.core.$strip>]>>;
            executions: z.ZodNumber;
            stdoutStreamUrl: z.ZodOptional<z.ZodString>;
            stderrStreamUrl: z.ZodOptional<z.ZodString>;
            networkEnabled: z.ZodOptional<z.ZodBoolean>;
            networkPort: z.ZodOptional<z.ZodNumber>;
            url: z.ZodOptional<z.ZodString>;
            org: z.ZodObject<{
                id: z.ZodString;
                name: z.ZodString;
            }, z.core.$strip>;
            timeout: z.ZodOptional<z.ZodObject<{
                idle: z.ZodOptional<z.ZodString>;
                execution: z.ZodOptional<z.ZodString>;
            }, z.core.$strip>>;
            command: z.ZodOptional<z.ZodObject<{
                exec: z.ZodArray<z.ZodString>;
                mode: z.ZodOptional<z.ZodEnum<{
                    oneshot: "oneshot";
                    interactive: "interactive";
                }>>;
            }, z.core.$strip>>;
        }, z.core.$strip>>;
        total: z.ZodNumber;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export interface SandboxListParams extends ListSandboxesParams {
    orgId?: string;
    deletedOnly?: boolean;
}
/**
 * Lists sandboxes with optional filtering and pagination.
 *
 * @param client - The API client to use for the request
 * @param params - Optional parameters for filtering by project, status, and pagination
 * @returns Paginated list of sandboxes with total count
 * @throws {SandboxResponseError} If the request fails
 */
export declare function sandboxList(client: APIClient, params?: SandboxListParams): Promise<ListSandboxesResponse>;
//# sourceMappingURL=list.d.ts.map