import type { Schema } from '../base';
import { SCHEMA_KIND } from '../base';
/**
 * Schema for validating null values.
 */
export declare class NullSchema implements Schema<null, null> {
    readonly [SCHEMA_KIND] = "NullSchema";
    description?: string;
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.FailureResult | import("@agentuity/core").StandardSchemaV1.SuccessResult<null>;
        types: {
            input: null;
            output: null;
        };
    };
    describe(description: string): this;
    optional(): import("..").OptionalSchema<this>;
    nullable(): import("..").NullableSchema<this>;
    parse: (this: Schema<any, null>, value: unknown) => null;
    safeParse: (this: Schema<any, null>, value: unknown) => import("..").SafeParseResult<null>;
}
/**
 * Create a null schema.
 */
export declare function null_(): NullSchema;
//# sourceMappingURL=null.d.ts.map