import { type EvalRunEventProvider, type EvalRunStartEvent, type EvalRunCompleteEvent } from '@agentuity/core';
/**
 * An implementation of the EvalRunEventProvider which wraps multiple providers
 */
export declare class CompositeEvalRunEventProvider implements EvalRunEventProvider {
    private providers;
    constructor(...providers: EvalRunEventProvider[]);
    /**
     * called when the eval run starts
     *
     * @param event EvalRunStartEvent
     */
    start(event: EvalRunStartEvent): Promise<void>;
    /**
     * called when the eval run completes
     *
     * @param event EvalRunCompleteEvent
     */
    complete(event: EvalRunCompleteEvent): Promise<void>;
}
//# sourceMappingURL=composite.d.ts.map