export function createSessionHooks(_ctx, _config) {
    const initializedSessions = new Set();
    return {
        async onMessage(input, _output) {
            const sessionId = extractSessionId(input);
            if (!sessionId)
                return;
            if (!initializedSessions.has(sessionId)) {
                initializedSessions.add(sessionId);
            }
        },
    };
}
function extractSessionId(input) {
    if (typeof input === 'object' && input !== null && 'sessionID' in input) {
        return input.sessionID;
    }
    return undefined;
}
//# sourceMappingURL=session.js.map