import type { EntityType } from './types';
export interface EntityContext {
    user?: {
        id: string;
        email?: string;
        name?: string;
    };
    org?: {
        id: string;
        name?: string;
    };
    project?: {
        id: string;
        name?: string;
    };
    repo?: {
        url?: string;
        path: string;
    };
}
export declare function getEntityContext(): Promise<EntityContext>;
export declare function entityId(type: EntityType, id: string): string;
export declare function parseEntityId(entityIdValue: string): {
    type: EntityType;
    id: string;
};
export declare function kvKey(entityIdValue: string): string;
export declare function resolveUserId(): Promise<string | undefined>;
export declare function resolveOrgId(): Promise<string | undefined>;
export declare function resolveProjectId(): Promise<string | undefined>;
export declare function resolveRepoId(): Promise<string | undefined>;
//# sourceMappingURL=entities.d.ts.map