/**
 * Log Collector for clean build logs
 *
 * Provides a mechanism to collect clean, non-animated log output
 * for streaming to external services (like Pulse) while keeping
 * animated TUI output for the user's terminal.
 *
 * Usage:
 * - Set AGENTUITY_CLEAN_LOGS_FILE env var to a file path
 * - TUI components call appendLog() for final state messages
 * - Logs are written to the file for the parent process to read
 */
/**
 * Check if log collection is enabled (via environment variable)
 */
export declare function isLogCollectionEnabled(): boolean;
/**
 * Initialize the clean logs file (clears any existing content)
 */
export declare function initCleanLogsFile(filePath: string): void;
/**
 * Append a clean log line (no ANSI codes, no animation)
 * Only appends if collection is enabled
 */
export declare function appendLog(message: string): void;
/**
 * Append multiple log lines
 */
export declare function appendLogs(messages: string[]): void;
//# sourceMappingURL=log-collector.d.ts.map