import { z } from 'zod';
import { APIClient } from '../api';
import { type Session } from './list';
export declare const _SessionGetRequestSchema: z.ZodObject<{
    id: z.ZodString;
}, z.core.$strip>;
export declare const SessionEvalRunSchema: z.ZodObject<{
    id: z.ZodString;
    created_at: z.ZodString;
    eval_id: z.ZodString;
    pending: z.ZodBoolean;
    success: z.ZodBoolean;
    error: z.ZodNullable<z.ZodString>;
    result: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, z.core.$strip>;
export interface SpanNode {
    id: string;
    duration: number;
    operation: string;
    attributes: Record<string, unknown>;
    children?: SpanNode[];
    error?: string;
}
export declare const SpanNodeSchema: z.ZodType<SpanNode>;
export declare const RouteInfoSchema: z.ZodNullable<z.ZodObject<{
    id: z.ZodString;
    method: z.ZodString;
    path: z.ZodString;
}, z.core.$strip>>;
export declare const AgentInfoSchema: z.ZodObject<{
    name: z.ZodString;
    identifier: z.ZodString;
}, z.core.$strip>;
export declare const EnrichedSessionDataSchema: z.ZodObject<{
    session: z.ZodObject<{
        id: z.ZodString;
        created_at: z.ZodString;
        updated_at: z.ZodString;
        deleted: z.ZodBoolean;
        deleted_at: z.ZodNullable<z.ZodString>;
        deleted_by: z.ZodNullable<z.ZodString>;
        start_time: z.ZodString;
        end_time: z.ZodNullable<z.ZodString>;
        duration: z.ZodNullable<z.ZodNumber>;
        org_id: z.ZodString;
        project_id: z.ZodString;
        deployment_id: z.ZodString;
        agent_ids: z.ZodArray<z.ZodString>;
        trigger: z.ZodString;
        env: z.ZodString;
        devmode: z.ZodBoolean;
        pending: z.ZodBoolean;
        success: z.ZodBoolean;
        error: z.ZodNullable<z.ZodString>;
        metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
        cpu_time: z.ZodNullable<z.ZodNumber>;
        llm_cost: z.ZodNullable<z.ZodNumber>;
        llm_prompt_token_count: z.ZodNullable<z.ZodNumber>;
        llm_completion_token_count: z.ZodNullable<z.ZodNumber>;
        total_cost: z.ZodNullable<z.ZodNumber>;
        method: z.ZodString;
        url: z.ZodString;
        route_id: z.ZodString;
        thread_id: z.ZodString;
        timeline: z.ZodOptional<z.ZodNullable<z.ZodUnknown>>;
        user_data: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>;
    agents: z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        identifier: z.ZodString;
    }, z.core.$strip>>;
    eval_runs: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        created_at: z.ZodString;
        eval_id: z.ZodString;
        pending: z.ZodBoolean;
        success: z.ZodBoolean;
        error: z.ZodNullable<z.ZodString>;
        result: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.core.$strip>>;
    route: z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        method: z.ZodString;
        path: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>;
export declare const SessionGetResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        session: z.ZodObject<{
            id: z.ZodString;
            created_at: z.ZodString;
            updated_at: z.ZodString;
            deleted: z.ZodBoolean;
            deleted_at: z.ZodNullable<z.ZodString>;
            deleted_by: z.ZodNullable<z.ZodString>;
            start_time: z.ZodString;
            end_time: z.ZodNullable<z.ZodString>;
            duration: z.ZodNullable<z.ZodNumber>;
            org_id: z.ZodString;
            project_id: z.ZodString;
            deployment_id: z.ZodString;
            agent_ids: z.ZodArray<z.ZodString>;
            trigger: z.ZodString;
            env: z.ZodString;
            devmode: z.ZodBoolean;
            pending: z.ZodBoolean;
            success: z.ZodBoolean;
            error: z.ZodNullable<z.ZodString>;
            metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
            cpu_time: z.ZodNullable<z.ZodNumber>;
            llm_cost: z.ZodNullable<z.ZodNumber>;
            llm_prompt_token_count: z.ZodNullable<z.ZodNumber>;
            llm_completion_token_count: z.ZodNullable<z.ZodNumber>;
            total_cost: z.ZodNullable<z.ZodNumber>;
            method: z.ZodString;
            url: z.ZodString;
            route_id: z.ZodString;
            thread_id: z.ZodString;
            timeline: z.ZodOptional<z.ZodNullable<z.ZodUnknown>>;
            user_data: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        }, z.core.$strip>;
        agents: z.ZodArray<z.ZodObject<{
            name: z.ZodString;
            identifier: z.ZodString;
        }, z.core.$strip>>;
        eval_runs: z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            created_at: z.ZodString;
            eval_id: z.ZodString;
            pending: z.ZodBoolean;
            success: z.ZodBoolean;
            error: z.ZodNullable<z.ZodString>;
            result: z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, z.core.$strip>>;
        route: z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            method: z.ZodString;
            path: z.ZodString;
        }, z.core.$strip>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
type SessionGetRequest = z.infer<typeof _SessionGetRequestSchema>;
/**
 * Get a single session by id
 *
 * @param client
 * @param request
 * @returns
 */
export type SessionEvalRun = z.infer<typeof SessionEvalRunSchema>;
/** @deprecated Use SessionEvalRun instead */
export type EvalRun = SessionEvalRun;
export type RouteInfo = z.infer<typeof RouteInfoSchema>;
export type AgentInfo = z.infer<typeof AgentInfoSchema>;
export type EnrichedSession = {
    session: Session;
    agents: AgentInfo[];
    evalRuns: SessionEvalRun[];
    timeline: SpanNode | null;
    route: RouteInfo;
};
export declare function sessionGet(client: APIClient, request: SessionGetRequest): Promise<EnrichedSession>;
export {};
//# sourceMappingURL=get.d.ts.map