/**
 * Vite Builder
 *
 * Utilities for running Vite builds (client, server, workbench)
 */
import type { Logger, DeployOptions } from '../../../types';
import type { BuildReportCollector } from '../../../build-report';
export interface ViteBuildOptions {
    rootDir: string;
    mode: 'client' | 'server' | 'workbench';
    dev?: boolean;
    port?: number;
    projectId?: string;
    orgId?: string;
    region?: string;
    deploymentId?: string;
    workbenchRoute?: string;
    workbenchEnabled?: boolean;
    /** Whether analytics is enabled (for beacon injection in client build) */
    analyticsEnabled?: boolean;
    logger: Logger;
    deploymentOptions?: DeployOptions;
    /** Optional collector for structured error reporting */
    collector?: BuildReportCollector;
    /** Optional config profile name (e.g., 'staging', 'test') for .env.{profile} files */
    profile?: string;
}
/**
 * Run a Vite build for the specified mode
 * Uses inline Vite config (customizable via agentuity.config.ts)
 */
export declare function runViteBuild(options: ViteBuildOptions): Promise<void>;
interface BuildResult {
    workbench: {
        included: boolean;
        duration: number;
    };
    client: {
        included: boolean;
        duration: number;
    };
    server: {
        included: boolean;
        duration: number;
    };
}
/**
 * Run all builds in sequence: client -> workbench (if enabled) -> server
 */
export declare function runAllBuilds(options: Omit<ViteBuildOptions, 'mode'>): Promise<BuildResult>;
export {};
//# sourceMappingURL=vite-builder.d.ts.map