/**
 * Rust-style TypeScript error formatting
 *
 * Formats TypeScript compiler errors in a style similar to Rust's compiler output,
 * with source code context, error highlighting, and helpful formatting.
 */
import type { GrammarItem } from './tsc-output-parser';
export interface FormatOptions {
    /** Project directory for resolving relative paths */
    projectDir: string;
    /** Maximum number of errors to display (default: all) */
    maxErrors?: number;
}
/**
 * Format TypeScript errors in Rust-style output
 */
export declare function formatTypeScriptErrors(items: GrammarItem[], options: FormatOptions): Promise<string>;
/**
 * Check if the parsed result contains any errors
 */
export declare function hasErrors(items: GrammarItem[]): boolean;
/**
 * Get the count of errors
 */
export declare function getErrorCount(items: GrammarItem[]): number;
//# sourceMappingURL=typescript-errors.d.ts.map