import { type GrammarItem } from '../../tsc-output-parser';
import type { BuildReportCollector } from '../../build-report';
interface TypeError {
    success: false;
    errors: GrammarItem[];
    output: string;
}
interface TypeUnknownError {
    success: false;
    output: string;
}
interface TypeSuccess {
    success: true;
}
type TypeResult = TypeError | TypeSuccess | TypeUnknownError;
export interface TypecheckOptions {
    /** Optional collector for structured error reporting */
    collector?: BuildReportCollector;
}
/**
 * run the typescript compiler and result formatted results
 *
 * @param dir the absolute path to the directory containing the project (must have tsconfig.json in this folder)
 * @param options optional configuration including error collector
 * @returns
 */
export declare function typecheck(dir: string, options?: TypecheckOptions): Promise<TypeResult>;
export {};
//# sourceMappingURL=typecheck.d.ts.map