'use client';
import { jsx as _jsx } from "react/jsx-runtime";
import { motion } from 'motion/react';
import { memo, useMemo } from 'react';
import { cn } from '../../lib/utils';
const ShimmerComponent = ({ children, as: Component = 'p', className, duration = 2, spread = 2, }) => {
    const MotionComponent = motion.create(Component);
    const dynamicSpread = useMemo(() => (children?.length ?? 0) * spread, [children, spread]);
    return (_jsx(MotionComponent, { animate: { backgroundPosition: '0% center' }, className: cn('relative inline-block bg-[length:250%_100%,auto] bg-clip-text text-transparent', '[--bg:linear-gradient(90deg,#0000_calc(50%-var(--spread)),var(--color-background),#0000_calc(50%+var(--spread)))] [background-repeat:no-repeat,padding-box]', className), initial: { backgroundPosition: '100% center' }, style: {
            '--spread': `${dynamicSpread}px`,
            backgroundImage: 'var(--bg), linear-gradient(var(--color-muted-foreground), var(--color-muted-foreground))',
        }, transition: {
            repeat: Number.POSITIVE_INFINITY,
            duration,
            ease: 'linear',
        }, children: children }));
};
export const Shimmer = memo(ShimmerComponent);
//# sourceMappingURL=shimmer.js.map