import { z } from 'zod';
import { APIClient } from '../api';
export declare const OrganizationSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
}, z.core.$strip>;
export declare const WhoamiResponse: z.ZodObject<{
    firstName: z.ZodString;
    lastName: z.ZodString;
    organizations: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>;
export declare const WhoamiResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        firstName: z.ZodString;
        lastName: z.ZodString;
        organizations: z.ZodArray<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type WhoamiResponse = z.infer<typeof WhoamiResponseSchema>;
export type User = z.infer<typeof WhoamiResponse>;
/**
 * Get the current authenticated user information
 *
 * @param client
 * @returns
 */
export declare function whoami(client: APIClient): Promise<User>;
//# sourceMappingURL=whoami.d.ts.map