import { z } from 'zod';
import { type APIClient } from '../api';
export declare const ProjectGetRequestSchema: z.ZodObject<{
    id: z.ZodString;
    mask: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
    keys: z.ZodOptional<z.ZodDefault<z.ZodBoolean>>;
}, z.core.$strip>;
export declare const ProjectSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    tags: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodString>>>;
    orgId: z.ZodString;
    cloudRegion: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    api_key: z.ZodOptional<z.ZodString>;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    secrets: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}, z.core.$strip>;
export declare const ProjectGetResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        description: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        tags: z.ZodOptional<z.ZodNullable<z.ZodArray<z.ZodString>>>;
        orgId: z.ZodString;
        cloudRegion: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        api_key: z.ZodOptional<z.ZodString>;
        env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        secrets: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
type ProjectGetRequest = z.infer<typeof ProjectGetRequestSchema>;
export type Project = z.infer<typeof ProjectSchema>;
export declare function projectGet(client: APIClient, request: ProjectGetRequest): Promise<Project>;
export {};
//# sourceMappingURL=get.d.ts.map