import type { LogLevel } from '@agentuity/core';
import type { SpanProcessor } from '@opentelemetry/sdk-trace-base';
import type { OtelResponse } from './otel';
/**
 * Configuration for user provided OpenTelemetry
 */
export interface CustomizedOtelConfig {
    endpoint: string;
    serviceName: string;
    resourceAttributes: Record<string, string>;
    headers: Record<string, string>;
}
interface OtelRegisterConfig {
    processors?: SpanProcessor[];
    logLevel?: LogLevel;
}
export declare function register(registerConfig: OtelRegisterConfig): OtelResponse;
export {};
//# sourceMappingURL=config.d.ts.map