import type { PluginInput } from '@opencode-ai/plugin';
import type { CoderConfig } from '../../types';
export interface ParamsHooks {
    onParams: (input: unknown, output: unknown) => Promise<void>;
}
export declare function createParamsHooks(ctx: PluginInput, _config: CoderConfig): ParamsHooks;
/**
 * Advertised magic words for users:
 *
 * - "brainstorm" - Activates creative mode (temperature → 0.8)
 * - "think hard" - Activates deep thinking mode (max reasoning budget)
 * - "dig deep" / "go deep" - Activates thorough mode (maxSteps → 50)
 *
 * These can also be triggered by specific phrases like:
 * - "be creative", "give me ideas", "explore options", "explore alternatives"
 * - "think deeply", "analyze carefully", "reason through this"
 * - "deep dive", "take your time", "be thorough", "be meticulous"
 *
 * Note: Triggers use multi-word phrases to avoid false positives from common words.
 */
//# sourceMappingURL=params.d.ts.map