import type { WorkbenchConfig } from '@agentuity/core/workbench';
import type React from 'react';
import type { WorkbenchContextType } from '../../types/config';
export declare function useWorkbench(): WorkbenchContextType;
interface WorkbenchProviderProps {
    config: Omit<WorkbenchConfig, 'route'> & {
        baseUrl?: string | null;
        projectId?: string;
    };
    env: {
        agentuity: boolean;
        authenticated: boolean;
        cloud: boolean;
    };
    children: React.ReactNode;
    portals?: {
        actionBar?: {
            pre?: React.ReactNode;
            post?: React.ReactNode;
        };
    };
}
export declare function WorkbenchProvider({ config, env, children, portals, }: WorkbenchProviderProps): import("react/jsx-runtime").JSX.Element;
export {};
//# sourceMappingURL=workbench-provider.d.ts.map