import { z } from 'zod';
import { APIClient } from '../api';
export declare const _ThreadDeleteRequestSchema: z.ZodObject<{
    id: z.ZodString;
}, z.core.$strip>;
export declare const ThreadDeleteResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
}, z.core.$strip>], "success">;
export type ThreadDeleteRequest = z.infer<typeof _ThreadDeleteRequestSchema>;
export type ThreadDeleteResponse = z.infer<typeof ThreadDeleteResponseSchema>;
/**
 * Delete a thread by id
 *
 * @param client
 * @param request
 * @returns
 */
export declare function threadDelete(client: APIClient, request: ThreadDeleteRequest): Promise<void>;
//# sourceMappingURL=delete.d.ts.map