import { createIssue, failure, success, createParseMethods, SCHEMA_KIND } from '../base';
import { optional } from '../utils/optional';
import { nullable } from '../utils/nullable';
const parseMethods = createParseMethods();
/**
 * Schema for validating undefined values.
 */
export class UndefinedSchema {
    [SCHEMA_KIND] = 'UndefinedSchema';
    description;
    '~standard' = {
        version: 1,
        vendor: 'agentuity',
        validate: (value) => {
            if (value !== undefined) {
                return failure([createIssue(`Expected undefined, got ${typeof value}`)]);
            }
            return success(value);
        },
        types: undefined,
    };
    describe(description) {
        this.description = description;
        return this;
    }
    optional() {
        return optional(this);
    }
    nullable() {
        return nullable(this);
    }
    parse = parseMethods.parse;
    safeParse = parseMethods.safeParse;
}
/**
 * Create an undefined schema.
 */
export function undefined_() {
    return new UndefinedSchema();
}
//# sourceMappingURL=undefined.js.map