import type { Schema } from '../base';
import { SCHEMA_KIND } from '../base';
/**
 * Schema for validating string values.
 *
 * @example
 * ```typescript
 * const schema = s.string();
 * const name = schema.parse('John'); // "John"
 * schema.parse(123); // throws ValidationError
 * ```
 */
export declare class StringSchema implements Schema<string, string> {
    readonly [SCHEMA_KIND] = "StringSchema";
    description?: string;
    private _min?;
    private _max?;
    private _email?;
    private _url?;
    readonly '~standard': {
        version: 1;
        vendor: string;
        validate: (value: unknown) => import("@agentuity/core").StandardSchemaV1.FailureResult | import("@agentuity/core").StandardSchemaV1.SuccessResult<string>;
        types: {
            input: string;
            output: string;
        };
    };
    describe(description: string): this;
    /**
     * Set minimum length.
     *
     * @example
     * ```typescript
     * const schema = s.string().min(3);
     * schema.parse('hello'); // "hello"
     * schema.parse('hi'); // throws ValidationError
     * ```
     */
    min(length: number): StringSchema;
    /**
     * Set maximum length.
     *
     * @example
     * ```typescript
     * const schema = s.string().max(10);
     * schema.parse('hello'); // "hello"
     * schema.parse('hello world'); // throws ValidationError
     * ```
     */
    max(length: number): StringSchema;
    /**
     * Validate email format.
     *
     * @example
     * ```typescript
     * const schema = s.string().email();
     * schema.parse('user@example.com'); // "user@example.com"
     * schema.parse('invalid'); // throws ValidationError
     * ```
     */
    email(): StringSchema;
    /**
     * Validate URL format.
     *
     * @example
     * ```typescript
     * const schema = s.string().url();
     * schema.parse('https://example.com'); // "https://example.com"
     * schema.parse('invalid'); // throws ValidationError
     * ```
     */
    url(): StringSchema;
    optional(): import("..").OptionalSchema<this>;
    nullable(): import("..").NullableSchema<this>;
    private _clone;
    parse: (this: Schema<any, string>, value: unknown) => string;
    safeParse: (this: Schema<any, string>, value: unknown) => import("..").SafeParseResult<string>;
}
/**
 * Create a string schema.
 *
 * @example
 * ```typescript
 * const nameSchema = s.string().describe('User name');
 * const name = nameSchema.parse('John');
 * ```
 */
export declare function string(): StringSchema;
//# sourceMappingURL=string.d.ts.map