import type { ReconnectConfig } from './types';
/**
 * Default reconnection configuration values.
 */
export declare const DEFAULT_RECONNECT_CONFIG: Required<ReconnectConfig>;
/**
 * Computes the backoff delay for a reconnection attempt using exponential backoff with jitter.
 *
 * The delay is calculated as:
 * `min(maxDelayMs, initialDelayMs * (multiplier ^ attempt)) + random(0, jitterMs)`
 *
 * @param attempt - The current attempt number (0-indexed)
 * @param config - Reconnection configuration
 * @returns The delay in milliseconds before the next reconnection attempt
 */
export declare function computeBackoff(attempt: number, config?: Partial<ReconnectConfig>): number;
/**
 * Sleeps for the specified number of milliseconds.
 *
 * @param ms - The number of milliseconds to sleep
 * @returns A promise that resolves after the specified delay
 */
export declare function sleep(ms: number): Promise<void>;
/**
 * Merges user-provided reconnect config with defaults.
 *
 * @param config - User-provided reconnect configuration
 * @returns Complete reconnect configuration with all values filled in
 */
export declare function mergeReconnectConfig(config?: Partial<ReconnectConfig>): Required<ReconnectConfig>;
//# sourceMappingURL=reconnect.d.ts.map