import type { Logger, FileToWrite } from '@agentuity/core';
import { APIClient } from '@agentuity/server';
import type { AuthData } from '../../../types';
export declare function createSandboxClient(logger: Logger, auth: AuthData, region: string): APIClient;
/**
 * Look up the region for a sandbox, using cache-first strategy.
 * Falls back to API lookup if not in cache.
 */
export declare function getSandboxRegion(logger: Logger, auth: AuthData, profileName: string | undefined, sandboxId: string, orgId?: string): Promise<string>;
/**
 * Cache the region for a sandbox after create/run operations
 */
export declare function cacheSandboxRegion(profileName: string | undefined, sandboxId: string, region: string): Promise<void>;
/**
 * Clear cached region for a sandbox after delete
 */
export declare function clearSandboxRegionCache(profileName: string | undefined, sandboxId: string): Promise<void>;
/**
 * Parse --file arguments and read file contents.
 *
 * Formats:
 * - <sandbox-path>:<local-path>  - explicit mapping (e.g., script.js:./local/script.js)
 * - <filename>                   - shorthand, uses same name for both (e.g., script.js -> script.js:./script.js)
 *
 * @returns Array of FileToWrite objects
 */
export declare function parseFileArgs(fileArgs: string[] | undefined): Promise<FileToWrite[]>;
//# sourceMappingURL=util.d.ts.map