/**
 * Route Discovery - READ-ONLY AST analysis
 *
 * Discovers routes by scanning src/api/**\/*.ts files
 * Extracts route definitions WITHOUT mutating source files
 */
import type { Logger } from '../../../types';
export interface RouteMetadata {
    id: string;
    filename: string;
    path: string;
    method: string;
    version: string;
    type: 'api' | 'sms' | 'email' | 'cron' | 'websocket' | 'sse' | 'stream';
    agentIds?: string[];
    config?: Record<string, unknown>;
    schema?: {
        input?: string;
        output?: string;
    };
}
export interface RouteInfo {
    method: string;
    path: string;
    filename: string;
    hasValidator: boolean;
    routeType: 'api' | 'sms' | 'email' | 'cron' | 'websocket' | 'sse' | 'stream';
    agentVariable?: string;
    agentImportPath?: string;
    agentName?: string;
    agentDescription?: string;
    inputSchemaVariable?: string;
    outputSchemaVariable?: string;
    inputSchemaImportPath?: string;
    inputSchemaImportedName?: string;
    outputSchemaImportPath?: string;
    outputSchemaImportedName?: string;
    inputSchemaCode?: string;
    outputSchemaCode?: string;
    stream?: boolean;
    pathParams?: string[];
}
/**
 * Extract path parameters from a route path.
 * Matches patterns like :id, :userId, :id?, *path, etc.
 */
export declare function extractPathParams(path: string): string[];
/**
 * Discover all routes in src/api directory (READ-ONLY)
 */
export declare function discoverRoutes(srcDir: string, projectId: string, deploymentId: string, logger: Logger): Promise<{
    routes: RouteMetadata[];
    routeInfoList: RouteInfo[];
}>;
export interface RouteConflict {
    type: 'duplicate';
    routes: Array<{
        method: string;
        path: string;
        filename: string;
    }>;
    message: string;
}
/**
 * Detect conflicts between routes
 */
export declare function detectRouteConflicts(routes: Array<{
    method: string;
    path: string;
    filename: string;
}>): RouteConflict[];
//# sourceMappingURL=route-discovery.d.ts.map