import { z } from 'zod';
import { APIClient } from '../api';
declare const SessionSchema: z.ZodObject<{
    id: z.ZodString;
    created_at: z.ZodString;
    updated_at: z.ZodString;
    deleted: z.ZodBoolean;
    deleted_at: z.ZodNullable<z.ZodString>;
    deleted_by: z.ZodNullable<z.ZodString>;
    start_time: z.ZodString;
    end_time: z.ZodNullable<z.ZodString>;
    duration: z.ZodNullable<z.ZodNumber>;
    org_id: z.ZodString;
    project_id: z.ZodString;
    deployment_id: z.ZodString;
    agent_ids: z.ZodArray<z.ZodString>;
    trigger: z.ZodString;
    env: z.ZodString;
    devmode: z.ZodBoolean;
    pending: z.ZodBoolean;
    success: z.ZodBoolean;
    error: z.ZodNullable<z.ZodString>;
    metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
    cpu_time: z.ZodNullable<z.ZodNumber>;
    llm_cost: z.ZodNullable<z.ZodNumber>;
    llm_prompt_token_count: z.ZodNullable<z.ZodNumber>;
    llm_completion_token_count: z.ZodNullable<z.ZodNumber>;
    total_cost: z.ZodNullable<z.ZodNumber>;
    method: z.ZodString;
    url: z.ZodString;
    route_id: z.ZodString;
    thread_id: z.ZodString;
    timeline: z.ZodOptional<z.ZodNullable<z.ZodUnknown>>;
    user_data: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.core.$strip>;
export { SessionSchema };
export declare const SessionListResponse: z.ZodArray<z.ZodObject<{
    id: z.ZodString;
    created_at: z.ZodString;
    updated_at: z.ZodString;
    deleted: z.ZodBoolean;
    deleted_at: z.ZodNullable<z.ZodString>;
    deleted_by: z.ZodNullable<z.ZodString>;
    start_time: z.ZodString;
    end_time: z.ZodNullable<z.ZodString>;
    duration: z.ZodNullable<z.ZodNumber>;
    org_id: z.ZodString;
    project_id: z.ZodString;
    deployment_id: z.ZodString;
    agent_ids: z.ZodArray<z.ZodString>;
    trigger: z.ZodString;
    env: z.ZodString;
    devmode: z.ZodBoolean;
    pending: z.ZodBoolean;
    success: z.ZodBoolean;
    error: z.ZodNullable<z.ZodString>;
    metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
    cpu_time: z.ZodNullable<z.ZodNumber>;
    llm_cost: z.ZodNullable<z.ZodNumber>;
    llm_prompt_token_count: z.ZodNullable<z.ZodNumber>;
    llm_completion_token_count: z.ZodNullable<z.ZodNumber>;
    total_cost: z.ZodNullable<z.ZodNumber>;
    method: z.ZodString;
    url: z.ZodString;
    route_id: z.ZodString;
    thread_id: z.ZodString;
    timeline: z.ZodOptional<z.ZodNullable<z.ZodUnknown>>;
    user_data: z.ZodOptional<z.ZodNullable<z.ZodString>>;
}, z.core.$strip>>;
export declare const SessionListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        created_at: z.ZodString;
        updated_at: z.ZodString;
        deleted: z.ZodBoolean;
        deleted_at: z.ZodNullable<z.ZodString>;
        deleted_by: z.ZodNullable<z.ZodString>;
        start_time: z.ZodString;
        end_time: z.ZodNullable<z.ZodString>;
        duration: z.ZodNullable<z.ZodNumber>;
        org_id: z.ZodString;
        project_id: z.ZodString;
        deployment_id: z.ZodString;
        agent_ids: z.ZodArray<z.ZodString>;
        trigger: z.ZodString;
        env: z.ZodString;
        devmode: z.ZodBoolean;
        pending: z.ZodBoolean;
        success: z.ZodBoolean;
        error: z.ZodNullable<z.ZodString>;
        metadata: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
        cpu_time: z.ZodNullable<z.ZodNumber>;
        llm_cost: z.ZodNullable<z.ZodNumber>;
        llm_prompt_token_count: z.ZodNullable<z.ZodNumber>;
        llm_completion_token_count: z.ZodNullable<z.ZodNumber>;
        total_cost: z.ZodNullable<z.ZodNumber>;
        method: z.ZodString;
        url: z.ZodString;
        route_id: z.ZodString;
        thread_id: z.ZodString;
        timeline: z.ZodOptional<z.ZodNullable<z.ZodUnknown>>;
        user_data: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export type SessionListResponse = z.infer<typeof SessionListResponseSchema>;
export type SessionList = z.infer<typeof SessionListResponse>;
export type Session = z.infer<typeof SessionSchema>;
export interface SessionListOptions {
    count?: number;
    projectId?: string;
    deploymentId?: string;
    trigger?: string;
    env?: string;
    devmode?: boolean;
    success?: boolean;
    threadId?: string;
    agentIdentifier?: string;
    startAfter?: string;
    startBefore?: string;
    metadata?: Record<string, unknown>;
}
/**
 * List sessions
 *
 * @param client
 * @param options filtering and pagination options
 * @returns
 */
export declare function sessionList(client: APIClient, options?: SessionListOptions): Promise<SessionList>;
//# sourceMappingURL=list.d.ts.map