/**
 * Composite Logger
 *
 * Combines multiple loggers to write to all of them simultaneously.
 * Used to send logs to both the console (respecting user log level)
 * and the internal trace logger (always at trace level for debugging).
 */
import type { Logger } from '@agentuity/core';
/**
 * A logger that delegates to multiple child loggers
 */
export declare class CompositeLogger implements Logger {
    private loggers;
    constructor(loggers: Logger[]);
    trace(message: unknown, ...args: unknown[]): void;
    debug(message: unknown, ...args: unknown[]): void;
    info(message: unknown, ...args: unknown[]): void;
    warn(message: unknown, ...args: unknown[]): void;
    error(message: unknown, ...args: unknown[]): void;
    fatal(message: unknown, ...args: unknown[]): never;
    child(opts: Record<string, unknown>): Logger;
    /**
     * Add a logger to the composite
     */
    addLogger(logger: Logger): void;
    /**
     * Get all loggers in the composite
     */
    getLoggers(): Logger[];
}
/**
 * Create a composite logger from multiple loggers
 */
export declare function createCompositeLogger(...loggers: Logger[]): CompositeLogger;
//# sourceMappingURL=composite-logger.d.ts.map