import { z } from 'zod';
/**
 * Base schema for snapshot build configuration file (agentuity-snapshot.yaml)
 * This is the canonical schema - used for JSON Schema generation.
 */
export declare const SnapshotBuildFileBaseSchema: z.ZodObject<{
    version: z.ZodLiteral<1>;
    runtime: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    dependencies: z.ZodOptional<z.ZodArray<z.ZodString>>;
    files: z.ZodOptional<z.ZodArray<z.ZodString>>;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    public: z.ZodOptional<z.ZodBoolean>;
}, z.core.$strip>;
/**
 * Schema with validation refinement - use this for parsing/validation.
 * Ensures at least one of dependencies, files, or env is specified.
 */
export declare const SnapshotBuildFileSchema: z.ZodObject<{
    version: z.ZodLiteral<1>;
    runtime: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    dependencies: z.ZodOptional<z.ZodArray<z.ZodString>>;
    files: z.ZodOptional<z.ZodArray<z.ZodString>>;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    public: z.ZodOptional<z.ZodBoolean>;
}, z.core.$strip>;
export type SnapshotBuildFile = z.infer<typeof SnapshotBuildFileSchema>;
//# sourceMappingURL=snapshot-build.d.ts.map