import { z } from 'zod';
import { APIResponseSchema } from '../api';
import { OrgResponseError } from './util';
export const ListOrganizationsResponse = z.array(z.object({
    id: z.string().describe('the unique id for the organization'),
    name: z.string().describe('the name of the organization'),
}));
export const ListOrganizationsResponseSchema = APIResponseSchema(ListOrganizationsResponse);
/**
 * List all organizations
 *
 * @param client
 * @returns
 */
export async function listOrganizations(client) {
    const resp = await client.get('/cli/organization', ListOrganizationsResponseSchema);
    if (resp.success) {
        return resp.data;
    }
    throw new OrgResponseError({ message: resp.message });
}
//# sourceMappingURL=list.js.map