import { z } from 'zod';
import { type APIClient } from '../api';
export declare const EvaluationSchema: z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    description: z.ZodNullable<z.ZodString>;
    identifier: z.ZodNullable<z.ZodString>;
    agentIdentifier: z.ZodString;
    projectId: z.ZodString;
    devmode: z.ZodBoolean;
    createdAt: z.ZodString;
    updatedAt: z.ZodString;
}, z.core.$strip>;
export declare const EvalListResponseData: z.ZodArray<z.ZodObject<{
    id: z.ZodString;
    name: z.ZodString;
    description: z.ZodNullable<z.ZodString>;
    identifier: z.ZodNullable<z.ZodString>;
    agentIdentifier: z.ZodString;
    projectId: z.ZodString;
    devmode: z.ZodBoolean;
    createdAt: z.ZodString;
    updatedAt: z.ZodString;
}, z.core.$strip>>;
export declare const EvalListResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodArray<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        description: z.ZodNullable<z.ZodString>;
        identifier: z.ZodNullable<z.ZodString>;
        agentIdentifier: z.ZodString;
        projectId: z.ZodString;
        devmode: z.ZodBoolean;
        createdAt: z.ZodString;
        updatedAt: z.ZodString;
    }, z.core.$strip>>;
}, z.core.$strip>], "success">;
export type Evaluation = z.infer<typeof EvaluationSchema>;
export type EvaluationListRequest = {
    projectId?: string;
    agentId?: string;
};
export declare function evalList(client: APIClient, request?: EvaluationListRequest): Promise<Evaluation[]>;
//# sourceMappingURL=list.d.ts.map