import { z } from 'zod';
import { APIResponseSchema } from '../api';
import { APIKeyResponseError } from './util';
export const APIKeyDeleteResponseSchema = APIResponseSchema(z.number().describe('number of rows affected'));
/**
 * Delete an API key (soft delete)
 *
 * @param client
 * @param id the API key id to delete
 * @returns number of rows affected
 */
export async function apikeyDelete(client, id) {
    const resp = await client.request('DELETE', `/cli/apikey/${id}`, APIKeyDeleteResponseSchema);
    if (resp.success) {
        return resp.data;
    }
    throw new APIKeyResponseError({ message: resp.message });
}
//# sourceMappingURL=delete.js.map