/**
 * Process protection utilities
 *
 * Prevents user code from calling process.exit() which would crash the server.
 * The runtime can still exit gracefully using the internal exit function.
 */
/**
 * Enable protection against process.exit calls.
 * After calling this, user code calling process.exit() will throw an error.
 */
export declare function enableProcessExitProtection(): void;
/**
 * Disable protection (mainly for testing)
 */
export declare function disableProcessExitProtection(): void;
/**
 * Internal function for the runtime to call when it needs to exit.
 * This bypasses the protection and calls the original process.exit.
 */
export declare function internalExit(code?: number): never;
/**
 * Check if protection is currently enabled
 */
export declare function isProtectionEnabled(): boolean;
//# sourceMappingURL=_process-protection.d.ts.map