/**
 * Error thrown when a concurrency waiter is cancelled.
 */
export declare const ConcurrencyCancelledError: {
    new (args?: ({
        key?: string;
    } & {
        cause?: unknown;
    }) | undefined): import("@agentuity/core").RichError & {
        readonly _tag: "ConcurrencyCancelledError";
    } & Readonly<{
        key?: string;
    }>;
    readonly defaultMessage?: string;
};
export interface ConcurrencyConfig {
    defaultLimit: number;
    limits?: Record<string, number>;
}
export declare class ConcurrencyManager {
    private defaultLimit;
    private limits;
    private counts;
    private queues;
    constructor(config?: Partial<ConcurrencyConfig>);
    getConcurrencyLimit(key: string): number;
    acquire(key: string): Promise<void>;
    release(key: string): void;
    cancelWaiters(key: string): void;
    clear(): void;
    getCount(key: string): number;
    getQueueLength(key: string): number;
    private getQueue;
    private flushQueue;
}
//# sourceMappingURL=concurrency.d.ts.map