/**
 * macOS Keychain integration for secure auth token storage
 *
 * Stores auth tokens encrypted in the macOS Keychain using a per-device AES-256 key.
 * No user prompts required - fully automatic and secure.
 */
/**
 * Check if we're running on macOS
 */
export declare function isMacOS(): boolean;
/**
 * Store auth data in macOS Keychain
 */
export declare function saveAuthToKeychain(profileName: string, authData: {
    api_key: string;
    user_id: string;
    expires: number;
}): Promise<void>;
/**
 * Retrieve auth data from macOS Keychain
 */
export declare function getAuthFromKeychain(profileName: string): Promise<{
    api_key: string;
    user_id: string;
    expires: number;
} | null>;
/**
 * Delete auth data from macOS Keychain
 */
export declare function deleteAuthFromKeychain(profileName: string): Promise<void>;
//# sourceMappingURL=keychain.d.ts.map