import { z } from 'zod';
import { APIClient } from '../api';
export declare const OrgEnvDataSchema: z.ZodObject<{
    id: z.ZodString;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    secrets: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}, z.core.$strip>;
export declare const OrgEnvGetResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        secrets: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
interface OrgEnvGetRequest {
    id: string;
    mask?: boolean;
}
export type OrgEnvGetResponse = z.infer<typeof OrgEnvGetResponseSchema>;
export type OrgEnv = z.infer<typeof OrgEnvDataSchema>;
/**
 * Get environment variables and secrets for an organization.
 * Secrets are masked by default unless mask=false is specified.
 * Note: Unmasked values require admin/owner role.
 */
export declare function orgEnvGet(client: APIClient, request: OrgEnvGetRequest): Promise<OrgEnv>;
export {};
//# sourceMappingURL=env-get.d.ts.map