import { type LogLevel } from '@agentuity/core';
import * as LogsAPI from '@opentelemetry/api-logs';
import type { Logger } from '../logger';
export declare const __originalConsole: Console;
export declare class OtelLogger implements Logger {
    private readonly delegate;
    private readonly context;
    private readonly logger;
    private readonly logLevel;
    constructor(useConsole: boolean, delegate: LogsAPI.Logger, context?: Record<string, unknown> | undefined, logLevel?: LogLevel);
    private formatMessage;
    private getAttributes;
    private emit;
    private shouldLog;
    trace(message: unknown, ...args: unknown[]): void;
    debug(message: unknown, ...args: unknown[]): void;
    info(message: unknown, ...args: unknown[]): void;
    warn(message: unknown, ...args: unknown[]): void;
    error(message: unknown, ...args: unknown[]): void;
    fatal(message: unknown, ...args: unknown[]): never;
    child(opts: Record<string, unknown>): Logger;
}
/**
 * Creates a logger that integrates with OpenTelemetry
 *
 * @param useConsole - Whether to also log to the console
 * @param context - Additional context to include with log records
 * @returns A logger instance
 */
export declare function createLogger(useConsole: boolean, context?: Record<string, unknown>, logLevel?: LogLevel): Logger;
/**
 * Patches the global console object to integrate with OpenTelemetry logging
 *
 * @param attributes - Attributes to include with all console log records
 */
export declare function patchConsole(enabled: boolean, attributes: Record<string, unknown>, logLevel: LogLevel): void;
//# sourceMappingURL=logger.d.ts.map