/**
 * Information about a tmux pane
 */
export interface TmuxPaneInfo {
    paneId: string;
    width: number;
    height: number;
    left: number;
    top: number;
    title: string;
    isActive: boolean;
}
/**
 * Ownership tags stored in tmux user options
 */
export interface TmuxOwnershipTags {
    isOpencode: boolean;
    serverKey: string;
    ownerPid: number;
    instanceId: string;
    sessionId?: string;
}
/**
 * Current state of the tmux window
 */
export interface WindowState {
    windowWidth: number;
    windowHeight: number;
    mainPane: TmuxPaneInfo | null;
    agentPanes: TmuxPaneInfo[];
}
/**
 * Tracked session for a background agent in tmux
 */
export interface TrackedSession {
    sessionId: string;
    paneId: string;
    pid?: number;
    description: string;
    createdAt: Date;
    lastSeenAt: Date;
}
/**
 * Direction for splitting panes
 */
export type SplitDirection = '-h' | '-v';
/**
 * Actions for managing panes
 */
export type PaneAction = {
    type: 'spawn';
    sessionId: string;
    description: string;
    targetPaneId: string;
    splitDirection: SplitDirection;
} | {
    type: 'close';
    paneId: string;
    sessionId: string;
} | {
    type: 'replace';
    paneId: string;
    oldSessionId: string;
    newSessionId: string;
    description: string;
};
/**
 * Decision result from the spawn decision engine
 */
export interface SpawnDecision {
    canSpawn: boolean;
    actions: PaneAction[];
    reason?: string;
}
/**
 * Capacity configuration for pane layout
 */
export interface CapacityConfig {
    mainPaneMinWidth: number;
    agentPaneMinWidth: number;
}
/**
 * Session mapping for decision engine
 */
export interface SessionMapping {
    sessionId: string;
    paneId: string;
    createdAt: Date;
}
/**
 * Configuration for tmux integration
 *
 * Agents spawn in a dedicated "Agents" window with tiled grid layout.
 * This keeps the main pane untouched while grouping all agent panes together.
 */
export interface TmuxConfig {
    enabled: boolean;
    maxPanes: number;
    mainPaneMinWidth: number;
    agentPaneMinWidth: number;
}
export declare const MIN_PANE_WIDTH = 52;
export declare const MIN_PANE_HEIGHT = 11;
export declare const POLL_INTERVAL_MS = 2000;
export declare const SESSION_MISSING_GRACE_MS = 5000;
export declare const SESSION_TIMEOUT_MS: number;
//# sourceMappingURL=types.d.ts.map