/**
 * Prompt Generator
 *
 * Generates AGENTS.md prompt files in .agents/agentuity/sdk/[type]/ directories.
 * Also creates reference files in src/[type]/AGENTS.md (write-once, only if missing).
 *
 * Uses hash tracking to detect template changes in .agents/ folder.
 * Reference files in src/ are never overwritten once created.
 *
 * Only runs in dev mode.
 */
import type { Logger } from '../../../types';
/**
 * Generate or update prompt files.
 *
 * - .agents/agentuity/sdk/[type]/AGENTS.md: Full content, updated when hash differs
 * - src/[type]/AGENTS.md: Reference file, only created if missing
 *
 * @param srcDir - The src/ directory path
 * @param logger - Logger for output
 */
export declare function generatePromptFiles(srcDir: string, logger: Logger): Promise<void>;
//# sourceMappingURL=prompt-generator.d.ts.map