import { z } from 'zod';
import { APIResponseSchema } from '../api';
import { APIKeyResponseError } from './util';
export const APIKeyCreateResponseSchema = z.object({
    id: z.string().describe('the API key id'),
    value: z.string().describe('the API key value'),
});
export const APIKeyCreateFullResponseSchema = APIResponseSchema(APIKeyCreateResponseSchema);
/**
 * Create a new API key
 *
 * @param client
 * @param request the API key creation request
 * @returns
 */
export async function apikeyCreate(client, request) {
    const resp = await client.post('/cli/apikey', request, APIKeyCreateFullResponseSchema);
    if (resp.success) {
        return resp.data;
    }
    throw new APIKeyResponseError({ message: resp.message });
}
//# sourceMappingURL=create.js.map