import { type SessionCompleteEvent, type SessionEventProvider, type SessionStartEvent } from '@agentuity/core';
/**
 * A composite implementation of SessionEventProvider that forwards events to multiple providers
 */
export declare class CompositeSessionEventProvider implements SessionEventProvider {
    private providers;
    constructor(...providers: SessionEventProvider[]);
    /**
     * called when the session starts
     *
     * @param event SessionStartEvent
     */
    start(event: SessionStartEvent): Promise<void>;
    /**
     * called when the session completes
     *
     * @param event SessionCompleteEvent
     */
    complete(event: SessionCompleteEvent): Promise<void>;
}
//# sourceMappingURL=composite.d.ts.map