export interface ReconnectOptions {
    onReconnect: () => void;
    threshold?: number;
    baseDelay?: number;
    factor?: number;
    maxDelay?: number;
    jitter?: number;
    enabled?: () => boolean;
}
export interface ReconnectManager {
    recordFailure: () => {
        scheduled: boolean;
        delay: number | null;
    };
    recordSuccess: () => void;
    cancel: () => void;
    reset: () => void;
    dispose: () => void;
    getAttempts: () => number;
}
export declare function createReconnectManager(opts: ReconnectOptions): ReconnectManager;
//# sourceMappingURL=reconnect.d.ts.map