import { z } from 'zod';
import type { APIClient } from '../../api';
declare const DevmodeResponseSchema: z.ZodObject<{
    id: z.ZodString;
    hostname: z.ZodString;
    privateKey: z.ZodOptional<z.ZodString>;
}, z.core.$strip>;
export type DevmodeResponse = z.infer<typeof DevmodeResponseSchema>;
/**
 * Generate an Endpoint ID and Hostname
 *
 * @param apiClient the api client to use
 * @param projectId the project id
 * @param hostname the hostname is already configured
 * @param privateKey the private key PEM if already configured
 * @returns
 */
export declare function generateEndpoint(apiClient: APIClient, projectId: string, hostname?: string, privateKey?: string): Promise<DevmodeResponse>;
export {};
//# sourceMappingURL=api.d.ts.map