import { z } from 'zod';
import { APIClient } from '../api';
export declare const OrgEnvDeleteRequestSchema: z.ZodObject<{
    id: z.ZodString;
    env: z.ZodOptional<z.ZodArray<z.ZodString>>;
    secrets: z.ZodOptional<z.ZodArray<z.ZodString>>;
}, z.core.$strip>;
export declare const OrgEnvDeleteResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
}, z.core.$strip>], "success">;
export type OrgEnvDeleteRequest = z.infer<typeof OrgEnvDeleteRequestSchema>;
export type OrgEnvDeleteResponse = z.infer<typeof OrgEnvDeleteResponseSchema>;
/**
 * Delete environment variables and/or secrets from an organization.
 * Provide arrays of keys to delete.
 * Requires admin/owner role.
 */
export declare function orgEnvDelete(client: APIClient, request: OrgEnvDeleteRequest): Promise<void>;
//# sourceMappingURL=env-delete.d.ts.map