import type { CoderConfig } from '../types';
/**
 * Returns the default config path without resolving the active profile.
 * Use loadCoderConfig() for actual config loading which resolves via getProfilePath().
 */
export declare function getDefaultConfigPath(): string;
/**
 * Returns the actual config path that will be used, resolving the active profile.
 */
export declare function getConfigPath(): Promise<string>;
/**
 * Load plugin configuration.
 *
 * This primarily loads the orgId from the Agentuity CLI profile.
 * Agent model configuration should be done via OpenCode's native opencode.json.
 *
 * Users can override agent models in their opencode.json:
 * ```json
 * {
 *   "agent": {
 *     "Agentuity Coder Architect": {
 *       "model": "openai/gpt-5.3-codex",
 *       "reasoningEffort": "xhigh"
 *     }
 *   }
 * }
 * ```
 */
export declare function loadCoderConfig(): Promise<CoderConfig>;
/**
 * Get default configuration.
 *
 * Note: Agent model defaults are defined in agent definition files (src/agents/).
 * Users can override agent models via opencode.json.
 */
export declare function getDefaultConfig(): CoderConfig;
export declare function mergeConfig(base: CoderConfig, override: CoderConfig): CoderConfig;
//# sourceMappingURL=loader.d.ts.map