import { type Logger } from '@agentuity/core';
import { type APIClient } from '@agentuity/server';
import type { AuthData, Config } from '../../types';
export type IdentifierType = 'project' | 'deployment' | 'sandbox' | 'stream';
/**
 * Determine the type of identifier based on its prefix
 */
export declare function getIdentifierType(identifier: string): IdentifierType;
/**
 * Look up the region for a project, deployment, sandbox, or stream identifier.
 * Uses cache-first strategy with API fallback.
 *
 * @param apiClient - Required for project/deployment lookups, optional for sandbox/stream
 *                    (they create their own clients internally)
 */
export declare function getIdentifierRegion(logger: Logger, auth: AuthData, apiClient: APIClient | undefined, profileName: string | undefined, identifier: string, orgId?: string, config?: Config | null): Promise<string>;
/**
 * Cache the region for a project after creation
 */
export declare function cacheProjectRegion(profileName: string | undefined, projectId: string, region: string): Promise<void>;
//# sourceMappingURL=region-lookup.d.ts.map