import { z } from 'zod';
import { type APIClient } from '../api.ts';
export declare const StreamDetailSchema: z.ZodObject<{
    id: z.ZodString;
    namespace: z.ZodString;
    metadata: z.ZodRecord<z.ZodString, z.ZodString>;
    url: z.ZodString;
    sizeBytes: z.ZodNumber;
    createdAt: z.ZodNullable<z.ZodString>;
    updatedAt: z.ZodNullable<z.ZodString>;
    startedAt: z.ZodNullable<z.ZodString>;
    endedAt: z.ZodNullable<z.ZodString>;
    expiresAt: z.ZodNullable<z.ZodString>;
    orgId: z.ZodString;
    projectId: z.ZodNullable<z.ZodString>;
    completed: z.ZodBoolean;
    headers: z.ZodRecord<z.ZodString, z.ZodString>;
    chunks: z.ZodNumber;
}, z.core.$strip>;
export declare const StreamDetailResponseSchema: z.ZodDiscriminatedUnion<[z.ZodObject<{
    success: z.ZodLiteral<false>;
    message: z.ZodString;
    code: z.ZodOptional<z.ZodString>;
}, z.core.$strip>, z.ZodObject<{
    success: z.ZodLiteral<true>;
    data: z.ZodObject<{
        id: z.ZodString;
        namespace: z.ZodString;
        metadata: z.ZodRecord<z.ZodString, z.ZodString>;
        url: z.ZodString;
        sizeBytes: z.ZodNumber;
        createdAt: z.ZodNullable<z.ZodString>;
        updatedAt: z.ZodNullable<z.ZodString>;
        startedAt: z.ZodNullable<z.ZodString>;
        endedAt: z.ZodNullable<z.ZodString>;
        expiresAt: z.ZodNullable<z.ZodString>;
        orgId: z.ZodString;
        projectId: z.ZodNullable<z.ZodString>;
        completed: z.ZodBoolean;
        headers: z.ZodRecord<z.ZodString, z.ZodString>;
        chunks: z.ZodNumber;
    }, z.core.$strip>;
}, z.core.$strip>], "success">;
export type StreamDetailResponse = z.infer<typeof StreamDetailResponseSchema>;
export type StreamDetail = z.infer<typeof StreamDetailSchema>;
/**
 * Get a specific stream by ID.
 *
 * @param client - The API client
 * @param id - The stream ID
 * @returns A promise that resolves to the stream details
 *
 * @example
 * const stream = await streamGet(client, 'stream_abc123');
 * console.log(`Namespace: ${stream.namespace}, Size: ${stream.sizeBytes} bytes`);
 */
export declare function streamGet(client: APIClient, id: string): Promise<StreamDetail>;
//# sourceMappingURL=get.d.ts.map