import { z } from 'zod';
/**
 * Regex pattern for validating npm/bun package specifiers.
 * Uses a blocklist approach: rejects shell injection characters while allowing
 * all legitimate specifier formats (names, scoped packages, URLs, git refs, etc.).
 *
 * Valid examples: "typescript", "@types/node", "opencode-ai@1.2.3",
 *   "https://github.com/user/repo", "git+https://github.com/user/repo.git",
 *   "github:user/repo", "file:../local-pkg"
 * Invalid examples: "foo bar", "pkg;rm -rf", "pkg|cat /etc/passwd", "$(evil)"
 */
export declare const NPM_PACKAGE_NAME_PATTERN: RegExp;
/**
 * Base schema for snapshot build configuration file (agentuity-snapshot.yaml)
 * This is the canonical schema - used for JSON Schema generation.
 */
export declare const SnapshotBuildFileBaseSchema: z.ZodObject<{
    version: z.ZodLiteral<1>;
    runtime: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    dir: z.ZodOptional<z.ZodString>;
    dependencies: z.ZodOptional<z.ZodArray<z.ZodString>>;
    packages: z.ZodOptional<z.ZodArray<z.ZodString>>;
    files: z.ZodOptional<z.ZodArray<z.ZodString>>;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    public: z.ZodOptional<z.ZodBoolean>;
}, z.core.$strip>;
/**
 * Schema with validation refinement - use this for parsing/validation.
 * Ensures at least one of dependencies, files, env, or packages is specified.
 */
export declare const SnapshotBuildFileSchema: z.ZodObject<{
    version: z.ZodLiteral<1>;
    runtime: z.ZodString;
    name: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    dir: z.ZodOptional<z.ZodString>;
    dependencies: z.ZodOptional<z.ZodArray<z.ZodString>>;
    packages: z.ZodOptional<z.ZodArray<z.ZodString>>;
    files: z.ZodOptional<z.ZodArray<z.ZodString>>;
    env: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    public: z.ZodOptional<z.ZodBoolean>;
}, z.core.$strip>;
export type SnapshotBuildFile = z.infer<typeof SnapshotBuildFileSchema>;
//# sourceMappingURL=snapshot-build.d.ts.map