import { type APIClient } from '../api.ts';
export interface SandboxGetStatusParams {
    sandboxId: string;
    orgId?: string;
}
export interface SandboxStatusResult {
    sandboxId: string;
    status: string;
    exitCode?: number;
}
/**
 * Retrieves lightweight sandbox status (status + exitCode only).
 * Optimized for the sandbox run flow — backed by Redis for ~1ms response time.
 */
export declare function sandboxGetStatus(client: APIClient, params: SandboxGetStatusParams): Promise<SandboxStatusResult>;
//# sourceMappingURL=getStatus.d.ts.map